<?php
/**
 * REST API Routes Registration trait for OpenApp Gateway.
 *
 * @package OpenApp_Payment_Gateway
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Trait OPENAPPGW_Trait_REST_API_Routes
 *
 * Handles REST API route registration for external and internal endpoints.
 */
trait OPENAPPGW_Trait_REST_API_Routes {

    public function exclude_specific_endpoint_from_rest( $is_rest_api_request ) {
        if ( empty( $_SERVER['REQUEST_URI'] ) ) {
            return $is_rest_api_request;
        }

        // Sanitize the REQUEST_URI
        $uri = sanitize_text_field( $_SERVER['REQUEST_URI'] );

        $uri_path = wp_parse_url($uri, PHP_URL_PATH);

        // Check if the path matches your specific endpoint
        if ( strpos($uri_path, '/openapp/v1/basket') !== false ) {
            return false;
        }

        return $is_rest_api_request;
    }

    public function register_openapp_routes_external() {

        register_rest_route(
            'openapp/v1',
            '/basket',
            array(
                'methods'  => 'POST',
                'callback' => array($this, 'create_or_update_basket'),
                'permission_callback' => '__return_true',
            )
        );


        register_rest_route(
            'openapp/v1',
            '/basket',
            array(
                'methods' => 'GET',
                'callback' => array($this,'retrieve_basket'),
                'permission_callback' => '__return_true',
                'args' => array(
                    'basketId' => array(
                        'validate_callback' => function($param, $request, $key) {
                            return !empty($param);
                        }
                    ),
                ),
            )
        );

        register_rest_route('openapp/v1', '/order', array(
            'methods' => 'POST',
            'callback' => array($this,'create_new_wc_order'),
            'permission_callback' => '__return_true',
        ));

        register_rest_route('openapp/v1', '/basket_recalculate', array(
            'methods' => 'POST',
            'callback' => array($this,'basket_recalculate'),
            'permission_callback' => '__return_true',
        ));

        register_rest_route( 'openapp/v1', '/identity', array(
            'methods' => 'POST',
            'callback' => array($this,'handle_identity'),
            'permission_callback' => '__return_true',
        ) );


        register_rest_route(
            'openapp/v1',
            '/products',
            array(
                'methods' => 'GET',
                'callback' => array($this,'retrieve_products'),
                'permission_callback' => '__return_true',
                'args' => array(
                    'full' => array(
                        'required' => false
                    )
                ),
            )
        );

        register_rest_route(
            'openapp/v1',
            '/order-return',
            array(
                'methods'  => 'POST',
                'callback' => array($this, 'handle_order_return'),
                'permission_callback' => '__return_true',
            )
        );
    }

    public function register_openapp_routes_internal(){
        register_rest_route('openapp/v1', '/qr_code', array(
            'methods' => 'GET',
            'callback' => array($this, 'get_qr_code_data'),
            'args' => array(
                'cart_id' => array(
                    'required' => true
                )
            ),
            'permission_callback' => '__return_true',
        ));

        register_rest_route('openapp/v1', '/oa_redirection', array(
            'methods' => 'GET',
            'callback' => array($this, 'oa_check_order_redirection'),
            'args' => array(
                'cart_id' => array(
                    'required' => true
                )
            ),
            'permission_callback' => '__return_true',
        ));

        register_rest_route('openapp/v1', '/oa_login', array(
            'methods' => 'GET',
            'callback' => array($this, 'oa_check_login'),
            'args' => array(
                'cart_id' => array(
                    'required' => true
                )
            ),
            'permission_callback' => '__return_true',
        ));
    }

}
