# OpenApp Gateway for PrestaShop
**Contributors:** openapp  
**Tags:** prestashop, payment gateway, openapp  
**Stable tag:** 2.0.0
**License:** GPLv2 or later

This module adds OpenApp as a payment gateway in PrestaShop, allowing customers to make payments using OpenApp.

## Description
The OpenApp Gateway for PrestaShop module integrates OpenApp as a payment method within your PrestaShop store. Customers can scan a QR code in their cart or during checkout and make payments directly from the OA mobile app.

### Third-Party Service Disclosure
This module relies on OpenApp, a third-party service, to process payments. When using this module, data may be transmitted to OpenApp for payment processing. For more details on how OpenApp handles data, please visit:

- [OpenApp Service](https://open-app.com)
- [OpenApp Terms of Use](https://open-app.com/terms-and-conditions/)

## Features
- Adds OpenApp as a payment gateway in PrestaShop.
- Display payment QR code on cart and checkout page.
- Enables login using the OA login feature (displayed below Login Form)

## Installation
1. Upload the module files to the `/modules/ps_openapp` directory. Alternatively, you can install the module directly through the PrestaShop modules interface.
2. Activate the module by navigating to the 'Modules' section in your PrestaShop dashboard.
3. Proceed to PrestaShop > Modules > Payment, locate 'PS Openapp', and enable it.
4. Configure the payment gateway settings according to your requirements.
5. Assign OpenApp mapping to each shipping method that you wish to display in the OpenApp application.
6. Regarding shipping costs: This module leverages PrestaShop's native functionality to determine shipping costs. Costs are calculated based on zones assigned to Poland (PL country), with 'Europe' being the default zone.

## Changelog

### 2.0.0 - 2025-12-10
- Add `oa_products`, `oa_order_return`, `oa_order_return_action` endpoints
- Rewrite `basket` and `basket_recalculate` endpoints
- Security: use DbQuery, json_encode instead of serialize
- Fix QR discounts, currency init, pagination, variations pricing
- Remove unused `hello` endpoint

### 1.0.5
- Updated OpenApp QR widget library URL to latest version (1.0.0)

### 1.0.4
- added support for `apartmentNo` in address details
- changed `hookActionOrderStatusUpdate` method to utilize the `multiFulfillment` endpoint instead of the `fulfillment`

### 1.0.3
- Prestashop 1.7.x compatibility

### 1.0.2
- Fix quantity being string

### 1.0.1
- Initial release
