<?php

require_once dirname(__FILE__) . '/OpenappAbstractRESTController.php';

/**
 * Protected REST endpoints should extend this class
 */
abstract class OpenappAbstractAuthRESTController extends OpenappAbstractRESTController
{
    public $auth = true;
    public $ssl = true;

    public function init()
    {
        header('Content-Type: ' . "application/json");


        
        if (!$this->context->customer->isLogged() && $this->php_self != 'authentication' && $this->php_self != 'password') {
            $this->ajaxRender(json_encode([
                'code' => 410,
                'success' => false,
                'message' => $this->trans('User Not Authenticated', [], 'Modules.Openapp.Admin')
            ]));
            die;
        }

        parent::init();
    }

    
}
