<?php

require_once dirname(__FILE__) . '/../OpenappAbstractRESTController.php';

class ps_openappqrcodeModuleFrontController extends OpenappAbstractRESTController
{
    protected function processGetRequest()
    {
        $cart_id = $this->context->cart->id;

        if (!empty($cart_id)) {

            $basket = $this->getStoredCartData($cart_id);

            // returns basket_not_found
            if( !$basket )
            {
                $this->sendError('basket_not_found', $this->trans('Basket not found', [], 'Modules.Openapp.Cart'), 404);
            }

            $basketData = $this->buildBasketArray($basket);

            // Apply cart discounts from PrestaShop Cart
            $cart = new Cart($cart_id);
            if (Validate::isLoadedObject($cart)) {
                $cartRules = $cart->getCartRules();
                $totalDiscountValue = 0;

                foreach ($cartRules as $cartRule) {
                    // Get the actual discount value applied to this cart
                    $discountValue = isset($cartRule['value_real']) ? (float)$cartRule['value_real'] : 0;
                    $totalDiscountValue += $discountValue;
                }

                if ($totalDiscountValue > 0) {
                    $basketData['price']['basketValue'] = max(0, $basketData['price']['basketValue'] - $this->groszeFormat($totalDiscountValue));
                }
            }

            if(!empty($basketData)){
                $createResponse = [
                    'merchant_id' => Tools::getValue('OA_MERCHANT_ID', Configuration::get('OA_MERCHANT_ID')),
                    'profile_id' => Tools::getValue('OA_PROFILE_ID', Configuration::get('OA_PROFILE_ID')),
                    'cart_id' => $cart_id,
                    'total_value' => $basketData['price']['basketValue'],
                    'currency' =>  $basketData['price']['currency'],
                    'unique_products_count' => count($basketData['products']),
                ];

                $this->ajaxRender(json_encode([
                    'code' => 200,
                    'success' => true,
                    'message' => $this->trans('Openapp QR data', [], 'Modules.Openapp.Cart'),
                    'psdata' => $createResponse
                ]));
                die;
            }

        }

        $this->ajaxRender(json_encode([
            'code' => 200,
            'success' => true,
            'message' => $this->trans('Cart is empty.', [], 'Modules.Openapp.Cart')
        ]));
        die;

    }
}
