
function oaDisplayQrCode(cartData) {
    const containers = document.querySelectorAll(".OpenAppCheckoutOrder");

    containers.forEach(container => {
        container.setAttribute("data-merchantId", cartData.psdata.merchant_id);
        container.setAttribute("data-integrationProfileId", cartData.psdata.profile_id);
        container.setAttribute("data-basketId", cartData.psdata.cart_id);
        container.setAttribute("data-basketValue", cartData.psdata.total_value);
        container.setAttribute("data-basketCurrency", cartData.psdata.currency);
        container.setAttribute("data-uniqueProductsCount", cartData.psdata.unique_products_count);

        if( container.getAttribute('data-lang') === '') {
            container.setAttribute("data-lang", cartData.psdata.lang);
        }

        container.classList.remove("isErrorOA");
        container.classList.remove("OpenAppCheckout-loading");
        container.classList.add("OpenAppCheckout");

        const OAEvent = new CustomEvent("OpenAppCheckout", {
            detail: {},
            bubbles: true,
            cancelable: true,
            composed: false,
        });

        container.dispatchEvent(OAEvent);
    });
}

function oaDisplayQaCodeError1(textMessage){
    const containers = document.querySelectorAll(".OpenAppCheckoutOrder");
    containers.forEach(container => {
        container.classList.remove("OpenAppCheckout");
        container.classList.add("OpenAppCheckout-loading");
        container.classList.add("isErrorOA");
        container.innerHTML = textMessage;
    });

}
(function ($) {
    $(document).ready(function($) {

        let qrOrder = document.querySelectorAll (".OpenAppCheckoutOrder");
 
        if( qrOrder.length > 0 ) 
        {

            let cartId = openappVars2_cartId;
            const errorTextMessage = openappVars2_errorTextMessage;
            
            let langCode = prestashop.language.language_code;
            let currencyCode = prestashop.currency.iso_code;

            // const errorTextMessage = openappVars.errorTextMessage;
            let redirectionInterval;

            let fetchQrCode = function() {
                $.ajax({
                    url: "/openapp/qr_code",
                    method: "GET",
                    data: {
                        "cart_id": cartId
                    },
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader("X-PS-Internal", "true");
                    },
                    success: function(response) {
                        // console.log('qr_order', response);
                        if(String(response.psdata.total_value) === "0" || String(response.psdata.total_value) === "0.00" || response.psdata === undefined ) {
                            oaDisplayQaCodeError1(response.message);
                        } else {
                            response.psdata.lang = langCode;
                            response.psdata.currency = currencyCode;
                            oaDisplayQrCode(response);
                            check_oa_redirection();
                        }
                    },
                    error: function(error) {
                        oaDisplayQaCodeError1(errorTextMessage);
                    }
                });
            };

            fetchQrCode();

            window.prestashop.on('updatedCart', fetchQrCode);

            function check_oa_redirection(){
            
                clearInterval(redirectionInterval);

                redirectionInterval = setInterval(function () {
                    $.ajax({
                        url: "/openapp/oa_redirection",
                        method: "GET",
                        data: {
                            cart_id: cartId,
                        },
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader("X-PS-Internal", "true");
                        },
                        success: function (response) {
                            // console.log( response );
                            if (response.redirect) {
                                window.location.href = response.url;
                            }
                        }
                    });
                }, 8500);
            }
        }
        

    });
})(jQuery);
